# Review Components of Education 4.0 in 21st Century Skills Frameworks: Systematic Review

Laura Icela González-Pérez $^ { 1 , * \oplus }$ and María Soledad Ramírez-Montoya $2 \textcircled { \mathbb { D } }$

Citation: González-Pérez, L.I.; Ramírez-Montoya, M.S. Components of Education 4.0 in 21st Century Skills Frameworks: Systematic Review. Sustainability 2022, 14, 1493. https://doi.org/10.3390/su14031493

Academic Editors: Sandro Serpa and Michail Kalogiannakis

Received: 26 October 2021   
Accepted: 20 January 2022   
Published: 27 January 2022

Publisher’s Note: MDPI stays neutral with regard to jurisdictional claims in published maps and institutional affiliations.

1 Facultad de Psicología, Universidad Autónoma de Nuevo León, Monterrey 64460, Mexico 2 Tecnologico de Monterrey, Institute for the Future of Education, Monterrey 64849, Mexico; solramirez@tec.mx \* Correspondence: lauraicela25@hotmail.com

Abstract: Responsive educational proposals to develop skills to meet the demands of Industry 4.0 have become imperative to guarantee inclusive, equitable, and quality education and promote lifelong learning opportunities for all, also reducing the negative impact of COVID-19 and the major post-pandemic social issues. This article analyzes which components of Education 4.0 have been considered in 21st century skills frameworks and identifies the teaching and learning methods and key stakeholders impacted. We conducted a systematic literature review (SLR) with research questions to highlight studies that address 21st century frameworks worldwide, identifying which teaching—earning strategies contain 4.0 components, their learning dimensions, and the targeted stakeholders. The findings allowed us to identify opportunities to create or improve 21st century skills frameworks with the required Education 4.0 components to develop future skills. Our study revealed the absence of these frameworks for teachers and schools. Most are oriented toward students, developing competencies through the dimensions of character, meta-learning, and linking active learning teaching strategies. This work presents studies incorporating innovative educational practices and the core Education 4.0 components. It concludes with a reflection on creating educational models to develop complex-reasoning competencies and auto-systemic thinking to support problemsolving and address social needs.

Keywords: Education 4.0; frameworks; 21st century skills; future skills; emerging technologies; STEM; STEAM; learning methods; educational innovation; higher education; reasoning for complexity

# 1. Introduction

Improving the integral training of individuals and promoting quality of life in society should be the primary objectives of education. The Sustainable Development Goals (SDGs) 2020 report [1] of the United Nations (UN) Agenda 2030 highlights that the efforts to guarantee inclusive, equitable, and quality education and promote lifelong learning for all (SDG4) have been negatively impacted by the months of absence from school and universities due to COVID-19, impacting educational outcomes. Although many schools offer learning through virtual classrooms, internet access for many students is limited. Additionally, successful teaching depends on the computer literacy of teachers, educational managers, and parents.

The World Economic Forum’s 2021 report [2] describes the major post-pandemic social issues (e.g., extreme weather, deaths from infections, climate action failure, environmental damage, digital gap, cyber failures, lifestyles in crisis). It emphasizes that the gap between the “haves” and “have nots” will widen if access to technology and capacity remain inequitable. Although exemplary countries promote innovation, cooperation, and determination, most have struggled with crisis management during the global pandemic. Four critical response areas to the challenges wrought by COVID-19 are institutional authority, risk financing, information gathering and sharing, and resources and vaccines.

Integral educational framework models allow us to observe and evaluate the competencies required within each discipline from different dimensions, including technological, pedagogical, contextual, and humanistic aspects. The 21st century frameworks provide strategies to identify the skills that students must acquire to enter the future workforce; therefore, educators are tasked to analyze whether the current competencies and learning methods are designed to achieve this. The Partnership for 21st Century Skills [3] is a collaborative organization of governments and businesses that defined a framework for developing the skills, aptitudes, and attitudes to succeed in the workplace and 21st century society. It lists three types of competencies: (1) learning skills (creativity and innovation, critical thinking, and problem-solving; communication and collaboration); (2) literacy skills (information literacy; media literacy; ICT literacy), and (3) life skills (flexibility and adaptability; initiative and self-direction; social and intercultural skills; productivity and accountability; leadership and responsibility). Among the competencies that have become highly relevant today is the reasoning for complexity, where professionals must have the capacity to reflect how to address changing world [4]. Morin (1990) suggests the need to go beyond scientific reasoning into areas such as systems thinking and critical thinking [5], and creative thinking and scientific thinking [6] to develop new solutions to meet societal needs.

The Fourth Industrial Revolution (4IR) is characterized by disruptive technologies, processes, and practices. For [7], the three most relevant technologies are artificial intelligence (AI), machine learning (ML), and algorithms. Incorporating these technologies requires updating educational systems, starting with the organization and management of the classroom, evaluation, pedagogy, ethics, and professional development; furthermore, the pandemic has raised other issues that require complex reasoning, communication, and remote global leadership skills.

To apply the components of Education 4.0, ref. [8] recommends going beyond developing thinking in the classroom to computational thinking using educational robotics and programming, developing students’ soft skills through emotional management, and creating moral dilemmas. Another reference is [9], which performs a systematic review of the correlation between 21st century competency frameworks and digital-competency frameworks. Their findings resulted in a model that integrates core competencies (e.g., information management, communication, collaboration, creativity, critical thinking, and problem-solving) and contextual competencies (e.g., ethical awareness, cultural awareness, flexibility, self-direction, and lifelong learning) to ensure academic programs that foster core, contextual, and digital competencies within holistic educational frameworks. Noh et al., 2021 [10] showed that teachers’ design-thinking mindset to develop their students’ creative thinking and innovation skills for Education 4.0 included user-centered designing, empathy, collaboration, optimism, experimentation, prototyping, and mindfulness of process.

It is necessary to analyze the curricula holistically to balance the various objectives of education with the soft and technical competencies required for the 4.0 Industrial Revolution 4.0, thereby ensuring that students comprehensively identify their talents. Ref. [11] conducted a systematic literature review (SLR), focusing on studies related to 21st century skills and teaching, evaluation, assessment, learning sequences, and curriculum design. The authors compared the Education 4.0 components that demonstrate the need to rethink disruptive technology and hybrid-classroom strategies in the 21st century. The authors suggested that teacher training programs incorporate these skills in their curricula, and guidance should be provided to align technological, pedagogical, and disciplinary elements with new methodological approaches to develop 21st century skills among students. Identifying the necessary competencies for Education 4.0 training is a great way to increase the training potential. Other SLR studies have contributed to curriculum design and teacher training; they raise questions about how to assess the technological and pedagogical elements that would be the most appropriate to develop the skills.

This article focuses on analyzing which components of Education 4.0 have been considered in 21st century-skills frameworks and identifying the teaching and learning methods and key stakeholders being impacted. To achieve this, we first describe the dimensions to analyze the studies in this systematic review, discuss Education 4.0 within Industry 4.0, and describe the learning dimensions and teaching and learning methods. Second, we present the method for conducting this study’s systematic literature review (SLR) and the answers to the research questions. We end the discussion with the teaching and learning methods to develop 21st century competencies in Education 4.0 and some of the critical elements of innovative educational practices. The conclusion discusses post-pandemic challenges, the digital gap, and the future research needed to assess the technology.

# 2. Materials and Methods

# 2.1. Context of the Study

This study mainly focuses on identifying which components of Education 4.0 are currently used in 21st century frameworks and which teaching and learning strategy is the most successful for developing future skills. The COVID-19 emergency context forced educators and educational institutions to rethink the future education scenarios. Singapore serves as a model to nations worldwide that want to prepare their workforce for the demands of the Fourth Industrial Revolution (4IR). Its holistic educational system is renowned for preparing science, education, engineering, and math students (STEM) how to learn rather than what to learn [12]. Education 4.0 and the future of work are less concerned with what is known conceptually and theoretically than how it can be applied, not only the synthesis and application of knowledge and skills but also the integration of this synthesis with relevant new technologies [13]. The design and assessment of learning must be based on theories, models, techniques, standards, criteria, pedagogies, and components that improve educational quality without borders, places, and timeframes, supported by new teaching and learning methods mediated by technology.

# 2.2. Education 4.0 in Industry 4.0

Digital transformation and Education 4.0 differ from traditional education because they are enabled, supported, and guided by technology, including artificial intelligence, data management, ubiquitous technologies, robots, cloud computing, and sustainable technologies. A 2018 report by PricewaterhouseCoopers (PwC) [14] identified that increased training in digital skills and Science, Technology, Engineering and Mathematics (STEM) fields would be required, and soft skills not easily automated by machines, such as creativity and flexibility. Ref. [15] adopted a generic definition for Education 4.0 in higher education institutions as aligning their services and curricula to prepare the future Industry 4.0 workforce with technologies to address critical challenges such as student experience, the skills gap, data management, innovations in teaching and learning, metrics, open science, research, and cybersecurity.

Education 4.0 relies on digital strategies, digital security, and proper infrastructure. Ref. [16] organized the enablers of digital transformation in Education 4.0 into six categories: (1) technological enablers, (2) organizational enablers, (3) digital competency teaching, (4) soft skills learner, (5) hard skills learner, and (6) pedagogies. Learning analytics are a vital element of Education 4.0 to predict students’ future performance and sustain their continuous improvement [17]. Integrating Industry 4.0’s educational components is the beginning of a model constructed to make the various agents in the educational system more flexible, including pedagogical practices and the technology that supports learning. The integration includes connectivity and storage infrastructure, institutional guidelines, organizational processes, and practices to promote innovation and training of teachers in digital competencies (doing and being) so they have the skills of the digital-native learners.

These initiatives and projects should align with the needs and requirements of educational institutions to respond to current social contexts, considering the drivers of technological megatrends that lead to innovative solutions. Miranda et al., 2021 [18] propose four core components of Education 4.0., which we used to analyze the studies in this SLR (see Table 1).

Table 1. Core components of Education 4.0 (based on Miranda et al., 2021 [18]).   

<html><body><table><tr><td colspan="3">Categories</td></tr><tr><td rowspan="2">Competencies</td><td>Transversal competencies</td><td>()</td></tr><tr><td>Disciplinary competencies.</td><td>(i) Training and developing functional, technical,and technological knowledge and successful workplace emerging technologies and best practices to propose technology-based solutions.</td></tr><tr><td rowspan="2">Learning methods</td><td>Learning delivery modalities.</td><td></td></tr><tr><td>Learning strategies</td><td>Pedagogical approaches such as challenge-based learning, problem-based learning, learning-by-doing,and gamification-based learning.</td></tr><tr><td rowspan="2">Information and communication technologies (ICT) categories</td><td>Technology-based</td><td>Artificial Intelligence and Machine Learning, ani Processing for virtual and experiential environments.</td></tr><tr><td>Tools and Platforms</td><td>Synchronous online sessions to support student learning through web conference technologies (e.g., ZOOM, Meets, Webex, M-Teams) and asynchronous learning platforms (Learning Management Systems, (LMS)).</td></tr><tr><td rowspan="2">Infrastructure levels</td><td>Classroom level</td><td>Innovative furniture; connected tools; classrooms, rooms, and libraries adapted with specific architecture,colors, illumination, sounds,and temperature to improve learning; virtual and augmented reality, and</td></tr><tr><td>Institutional level</td><td>hologram systems. Includes recreation, comfort, sustainability,and accessibility; services such as online libraries,instant messaging systems, remote laboratories enabled and widely used; access to internet services.</td></tr></table></body></html>

The challenges of the future of education entail different perspectives: assessing the success of learning with digital media, determining the framework of student competencies, homogenizing the skills that teachers must have to meet the demands of a globalized and digitalized society, and incorporating emerging and disruptive technologies that help achieve the meaningful learning of students.

# 2.3. Learning Dimensions

Governmental public policies worldwide are reviewing and determining the job skills that individuals must possess to compete in globalized markets, such as massive data management, artificial intelligence, and robotics, while also considering the wellbeing and human development of workers. Ref. [19] mapped the soft skills needed for the new green jobs emerging from the research plans of governments, such as sustainable and connected mobility strategies, the modernization of public administration, the 5G roadmap, the new economy of care and wellness, the digitalization of the education system, among others. Ref. [20] points out that labor competencies depend on individuals’ emotions as a fundamental psychological component of skills developed for work. These complete the engine that generates actions. Thus, cognitive and emotional factors allow individuals to analyze their environment and make the best decisions [21]. According to the Organization for Economic Cooperation and Development (OECD) [22], the new skills needed for employment are well served by a database of skills-jobs mismatch indicators comparable across countries and regularly updated, providing a comprehensive and detailed overview of skills shortages and surpluses across countries.

In this systematic literature review, we used the four-dimensions-of-learning model of the Center for Curriculum Redesign (CCR) [23], which are the knowledge, skills, character, and meta-learning dimensions, defined below:

(1) Knowledge dimension: refers to teaching topics that constitute the traditional and modern disciplines important to many jurisdictions and cultures. Teachers, students, and curriculum designers can find innumerable ways to highlight the core subject areas. This dimension considers digital literacy, synthesis, and integration of design thinking, ethical mindset, information literacy, socio-environmental literacy, empathy, and shared responsibility. It includes global literacy, information culture, systems thinking, environmental culture, and digital culture.   
(2) Skills dimension: focuses on students developing skills through active roles in realworld situations that promote self-regulation, communication, and reflection, successfully transferring knowledge and learning to ever-changing situations. They are expected to develop creativity, critical thinking, communication, and collaboration competencies.   
(3) Character dimension: refers to character education to build the foundation for lifelong learning, supporting successful relationships in the home, community, and workplace, and developing personal values and virtues for sustainable participation in the globalized world. The competencies in this dimension include mindfulness, curiosity, courage, resilience, ethics, and leadership.   
(4) Meta-learning dimension: involves higher-level thinking processes, which control lower-level thinking and the internalization of a growth mindset. Learning-oriented students see mistakes as opportunities for growth and improvement, while performanceoriented learners see them as failures. This dimension features three verbalizations: verbalization of knowledge that is already verbal (such as remembering what happened in a story), verbalization of nonverbal knowledge (such as remembering how a Rubik’s cube was solved), and verbalization of the explanations of verbal or nonverbal knowledge.

The dimensions of learning seek to impact the design of competency-based curricula by integrating the four dimensions of learning into educational models since many frameworks do not cover all the dimensions of lifelong learning and “learning-to-learn” competencies.

# 2.4. Stakeholders in the Competency Frameworks of the 21st Century

The 21st century skills, knowledge, and attitudes are necessary for citizens to face the digital, sustainable, and social world ethically and humanistically. The Cedefop glossary of the European Commission [24] defines skill as the ability to perform tasks and solve problems. It points out that competency means applying learning outcomes in each context (education, work, personal, or professional development). Students, teachers, and school principals [25] are the main stakeholders in Education 4.0, each with different competency development perspectives. Collaborative and interactive learning environments for Generation $Z$ students [26] require developing autonomous learning, creative thinking, problem-solving, critical thinking, communication, and collaboration skills. Refs. [27,28] suggest that, to address the digital divide issues, policymakers and educational institutes must undertake constructive educational reform in higher education curricula, especially in STEM programs with disruptive technologies, to incorporate the skills and competencies needed to deploy emerging technologies [12,14]. Therefore, school managers in Education 4.0 are expected to value and assess technologies and lead other school stakeholders to acquire technological skills to operate hybrid environments. Aligning education with the expectations of Industry 4.0 is possible when governments and educational institutions build adequate infrastructure to facilitate learning and learning networks that allow joint initiatives with society, thus reducing the digital gap.

New approaches to collaborative spaces, called FabLab or Makerspaces, promote various collaborative activities with different sectors. Two leading frameworks developed are DigiComp [29] and EntreComp [30,31] researched using focus groups in a makerspace to identify the competencies promoted in the DigiComp 2.1 and EntreComp frameworks. Their findings showed that students acquired planning skills, teamwork skills, public speaking, additive manufacturing skills, multidisciplinary thinking, and independent work skills. Partnering with Industry 4.0 requires considering all the educational actors and contemplating inclusive architectural spaces, learning strategies, and technology to solve problems efficiently in a society challenged by constant changes and uncertainty.

# 2.5. Teaching and Learning Methods

The new educational paradigms underpinning the 21st century frameworks aim to develop holistic competencies with integrated technological tools, thus requiring teaching– learning strategies to be effectively applied. The teaching–learning methods guide a logical, sequenced, and organized process to achieve objectives and evaluate learning, and the most appropriate technologies must be considered to accomplish this. Robotics is a new interdisciplinary teaching tool that offers the possibility of improving school performance, increasing motivation, and developing social skills, cooperative work, and creativity, among others [32]. The introduction of computational thinking refers to solving problems, designing systems, and understanding human behavior using the fundamental concepts of informatics [33]. Ramírez-Montoya, 2012 [34] presented five categories of active pedagogies focusing on teaching thinking skills, knowledge application, research practices, collaborative strategies, and the promotion of digital skills (see Table 2). We reviewed the studies selected for this SLR with this selection of categories.

Table 2. Categories of active pedagogies (based on Ramírez-Montoya, 2012 [34]).   

<html><body><table><tr><td> Strategy Category</td><td>Techniques</td><td>Description Reflection strategies include professional</td></tr><tr><td>self-regulated thinking. Reflection strategies to encourage</td><td>Case-based learning. Metronir rorftdioso</td><td>self-perception,understanding, creativity, refetygnsa improvements, social commitment,and others.</td></tr><tr><td> Rply hswategies to</td><td></td><td>knowledge in specific situations.</td></tr><tr><td>Construction strategies to promote analysis.</td><td>Debate. Argumentation. Problem-based learning.</td><td>Can be used in face-to-face, b-learning, e-learning and m-learning environments, where spaces foster collaborative learning and systemic self-learning.</td></tr><tr><td>Contextualization strategies to foster collaboration.</td><td>Authentic. Etuated learning,</td><td>Collaborative learning is one of the main goals to achieve high levels of cognition in meaning and eventialuatitlprossial interpersonal benefits.</td></tr><tr><td>Technoomediatedtrategies digital competencies.</td><td>Learning objects. Open educational resources. Mobile learning.</td><td>Information access and use skills that form the basis for continuous lifelong learning are their research,become more self-directed,and assume greater control over their learning process.</td></tr></table></body></html>

On the other hand, we must consider that we are evolving towards educational neurotechnology that proposes new ways of processing information in the human brain. A methodological change with pedagogical and technological intention is required in the educational model, embracing that the internet has changed producing, creating content, communicating, having fun, and processing information [31,35]. One of the crucial components for empowering teachers and students in these practices will play the role of the library, since the formation of proactive information culture strengthens an academic’s position in creating and use the information and by making them ready for digital transformation of the diverse approaches in the universities [36]. Providing access to information and knowledge databases to the academic community is a competitive advantage, but training should also be provided to know how to search, select, store and share information becomes a practice representative of a digitally literate society.

Implementing emerging technologies in the classroom learning methodologies reinforces learning in each educational stage. Scenarios with immersive technology such as augmented reality, contributes to a high level of presence and the simulation of realistic scenarios in a course [37]. On the other hand, the inclusion of Immersive Virtual Reality (IVR), associated with manipulative/experiential activities based on the STEM approach positively impacts the scientific-mathematical attitudes of participating students [38]. It´s not enough to have technology, its necessary to have pedagogical methodologies that favor learning.

Educational innovation is an evolution of teaching and learning methods and techniques, which are driven by new social, political, cultural and technological trends. University maker spaces provide and environment for collaborative learning and reinforce the teaching-learning process [39]. Suggestions to promote and enhance current creative education in STEM Maker education and meet the needs of students and teachers [40] recommend the development of new learning materials and online learning systems through the integration of product design and computer-aided design (CAD). Maker spaces generate possibilities to train the general public of any age in open innovation practices with technologies such as robots, electronics, 3D printers, research laboratories, so it is essential for governments and educational institutions to make available to the public such spaces.

From the perspective STEM education (Science, Technology, Engineering and Mathematics) the incorporation of the disciplines of behavioral sciences, humanities and art is demanded., in order to favor an integral education. An example is the theoretical model of Van den Hurk et al. (2019) [41] focuses on three types of factors that may affect persistence of learning in STEM: (1) environmental factors (e.g., the social context and social environment); (2) school-level factors (e.g., instruction, teachers, and pedagogy); and (3) student-level factors (e.g., students’ attitudes, motivation and aptitude). An other important aspect of STEM education is the design of STEM activities, for this design influences how the activities mediate students’ experiences in the STEM Classroom [42]. The sistematic review of Kayan-Fadlelmula, et al. (2022) [43] revealed an absence of research that explores enablers thay may enhance student participation in STEM-related fields of study and careers. The integration of diverse learning dimensions is a key to developing 21st century competencies and enabling Industry 4.0 requirements to face ambiguous and changing global scenarios.

# 2.6. Systematic Literature Review Method

To carry out the study, we used a systematic literature review (SLR) as a strategy to identify studies about frameworks created by various educational institutions, international bodies, and governments to develop 21st century competencies and analyze their potential to be incorporated in Education 4.0. SLRs are used to identify, evaluate, and interpret the data available within a period in each field of research. The process of this review is supported, in general terms, by the guidelines established by [44], focused on conducting SLRs in software engineering [38], and the contributions of [45–47]. The five phases of the review are shown in Figure 1.

![](images/fe7c288a22f25eb7aa0f245b16c79061dad3ec377ac8f2295123d045bbebb3fb.jpg)  
Figure 1. Systematic literature review process (own elaboration, based on Brereton, et al., 2007 [44]; Higgins & Green, 2006 [45]; Kitchenham, 2004 [46]; Chambers et al., 2009 [47]).

Phase 1. Research questions

During phase 1, eight questions were established to analyze the research published (unlimited until 2021). The questions were designed to cover the research’s objective and identify relevant and specific characteristics that could answer the questions shown in Table 3 [44,48].

Table 3. Research questions (own elaboration).   

<html><body><table><tr><td>Dimension</td><td>Research Questions (RQ)</td><td>Type of Answer Sought</td></tr><tr><td>Characteristics of published studies of frameworks for 21st century skills.</td><td>RQ1.What were the articles&#x27;objects of study? RQ2.owaeo learning targeted?</td><td>Id of articles and references. No. of articles in the Scopus and WS databases from 2006 to 2020? Leainedieeasie 2015)</td></tr><tr><td>Comprat.tei</td><td></td><td>Teaching and learning Strategies (Ramirez-Montoya,2012): Collaborative Contextualized Application Rechntlogy-mediated Core Education 4.0 (Miranda et al., 2021) Competencies Learning methods Information and communication technologies (ICT) Infrastructure</td></tr><tr><td>Led siakedidensions</td><td>RQ4.Who are the stakeholders identified in the publications,and what core Education 4.0 competencies have been worked on in the frameworks?</td><td>Stakeholders (Own classification): Teachers Students Schools CCR Learning dimensions (Fadel et al., 2015): Skills Knowledge Character Meta-learning</td></tr></table></body></html>

Phase 2. Search process

The search process in the SCOPUS and WoS databases began with defining the keywords to use in their search engines with the AND operator, per the inclusion and exclusion criteria. The search was performed on September 4, 2021. The search string for both databases is shown in Table 4.

Table 4. Keyword search.   

<html><body><table><tr><td>Scopus</td><td>Wos</td></tr><tr><td>(TITLE-ABS-KEY (&quot;twenty-first century skills&quot;)</td><td> TEMA: (&quot;twenty-first century skils&quot;) AND</td></tr><tr><td>AND TITLE-ABS-KEY (frameworks))</td><td>TEMA: (frameworks)</td></tr></table></body></html>

Phase 3. Inclusion and extraction criteria

The search protocol and guidelines for selecting and evaluating relevant studies were developed as follows:

Search resources: Scopus database and Web of Science database.

Categories and keywords: (“Frameworks”), (“twenty-first century skills”).

Inclusion criteria: Period: Unlimited until 2021. Type of document: articles; Language: English.

Inclusion criteria: Conference and proceedings, papers, books; duplicate.

Phase 4. Data selection and extraction process

In phase 4, the articles were searched, then data extraction was performed. Subsequently, the information was input into an Excel database. The search resulted in 113 studies: 63 in Scopus and 50 in WoS. The information extracted from each article included the author(s), keywords, title, type of access, year of publication, name of publication, number of citations, DOI number, affiliations, language, country, and abstract. Based on these data, 41 duplicate articles were identified and moved to another database sheet, resulting in 72 articles. After the selection was applied according to the type of study, there were 56 articles as review candidates. Figure 2 shows the delimitation based on the PRISMA method [49].

Phase 5. Data Synthesis

In phase 5, the classification sought to identify studies addressing twenty-first century frameworks in the WOS and SCOPUS databases and answer research questions RQ1, RQ2, RQ3, RQ4, and RQ5 described in Table 4. We sought to identify the teaching and learning strategies applied, the stakeholders, the learning dimensions, and their classification in the core of Education 4.0. The abstract’s information, keywords, and title were reviewed to categorize each article properly.

![](images/d733c22e5a61702e7b0efd2631caea999d7dc01985e9251076e7397da1a571d2.jpg)  
Figure 2. Selection process (PRISMA based on Page et al., 2021 [49]).

# 3. Results

The systematic literature review methodology results documented in an Excel database are available at the following address: https://zenodo.org/record/5574275 (accessed on 25 October 2021). This section presents the results related to the research questions. The tools used for the graphs were Excel and Tableau.

# RQ1. What were the articles’ objects of study?

The articles under study are presented in Table 5. The Id is the article identifier number for identification purposes in the following sections of this article. A summary of each article found is detailed below. These frameworks highlight educational models and learning strategies to develop future skills in educational institutions that align with the demands of Industry 4.0 (Appendix A).

Table 5. Studies in the SLR.   

<html><body><table><tr><td>Id (Appendix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0</td></tr><tr><td>A1</td><td>A framework for the theory-driven design of digital learning environments (FDDLEs) using the example of problem-solving in chemistry education (Tiemann and Annaggar, 2020)</td><td>The framework consists of the steps “Analysis&quot;,&quot;Design&quot;,&quot;Development&quot;,&quot;Quality Assurance&quot; and &quot;Evaluation &amp; Implementation.&quot;Each step is characterized by a defined milestone, which, together with a cycle between crucial and non-arbitrary steps, indicates a product and goal orientation for development that distinguishes the model from conventional approaches.</td></tr><tr><td>A2</td><td>Afre</td><td>This article emphasized twenty-first century skills,such as solving authentic problems. It idtecatiedadiliiposlniaeh framework can be used to develop STEM competencies and computer science education</td></tr><tr><td>A3</td><td>Activelerign rnmatiand uenty hers grali</td><td>This study shows the results of a quantitative analysis utilizing a regression analysis. It provided collaborative learning provided the theoretical framework for the active learning measurements.</td></tr><tr><td>A4</td><td></td><td>This study examined the diferent types of verbal episodes (questions, conflict, and reasoning episodes) in engineering student teams and how these verbal interactions related to individual and team performances. Collaborative problem-solving in team settngs is a critical practice in interactions and promote student verbal exchanges to boost student learning and produce positive team outcomes.</td></tr><tr><td>A5</td><td>trorgntieieutrtheonemiE: Analyzid n Es course (Portman and Broido, 2019)</td><td>Common European Framework (CEFR) provides valuable guidance to help institutions develop professional, in terms of English can-dos (mostly B2-C1),as described in the 2018 CEFR Companion Volume. The pedagogy underpinning the course is three-pronged, drawing on English for specific purposes, twenty-first century skills,and the CEFR.</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>(Appedix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0</td></tr><tr><td>A6</td><td>Assessing University Students&#x27;CriticalOnline Reasoning Ability: A Conceptual and Assessment Framework with Preliminary Evidence (Molerov, et al.,2020)</td><td>This paper presents a conceptual framework for Critical Online Reasoning (COR), based on prior approaches (&quot;information problem-solving&quot; &quot;multiple-source comprehension,&quot; &quot;web credibility,&quot; &quot;informal argumentation,&quot; and &quot;critical thinking&quot;). Critical evaluation skills of online information are considered necessary in many research and education frameworks. Higher education students are more likely to use the internet instead of ofline sources such as textbooks when studying for exams. The internet poses various challenges, including a large amount of incomplete,contradictory, erroneous,and biased information,and needs a curated learning environment. Despite the central importance of critically evaluating online information, its assessment in higher education is stillan emerging field.</td></tr><tr><td>A7</td><td>Assessment of University Students&#x27; Critical Thinking: Next Generation Performance Assessment (Shavelson et al.,2019)</td><td>This approach leads to developing the project iPAL (The international Performance Assessment of Learning) framework, consolidating previous research and focusing on next-generation performance assessments. This paper presents iPAL&#x27;s assessment framework and shows how it guides the development of performance assessments, exemplifying these assessments with a concrete task and providing preliminary evidence of its reliability and validity.</td></tr><tr><td>A8</td><td>Blended learning model in a vocational educational training hospitality seting: from teachers&#x27; perspectives (Zgraggen,2021)</td><td>This research study explored the Vocational Educational Training (VET) teachers&#x27; perspectives and experiences of a proposed Conceptual Blended Learning Framework (CBLF) model in a VET hospitality setting at the William Anglis Institute of Sydney (WAIS). This paper introduces the Design-led Education Innovation Matrix, providing a prototype</td></tr><tr><td>A9</td><td>Broadening design-led education horizons: conceptual insights and future research directions (Wright and Wrigley, 2019)</td><td>design-led framework to assist educators in developing and accessing twenty-first century knowledge,skills,and mindsets.In addition,it identifies related future research areas for academia, thereby extending the reach and scope of this emerging research area. It is a comprehensive literature review on educating a workforce for the knowledge economy. The role of design in business and educational innovation has contributed to a new approach to building a culture of practice for design-led education, based on the theory of the Innovation Matrix.</td></tr><tr><td>A10</td><td>Challenges Beyond Schooling: Innovative Models for Youth Skills Development in India (Mehrotra and Mehrotra, 2018)</td><td>The paper discusses the steps taken by the government to improve the articulation of vocational education in higher education, thus changing the “dead end&quot; image of vocational education. esec</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>(Appendix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0</td></tr><tr><td>A11</td><td>Computational Thinking and Media and Information Literacy: An Integrated Approach to Teaching Twenty-First Century Skills (Gretter and Yadav, 2016)</td><td>Developing students&#x27;21st century skills,including creativity,critical thinking, and problem-solving, has been a prevailing concern in our globalized and hyper-connected society. This article proposes an integrated approach to develop students&#x27; 21st century skils in the classroom,considering computational thinking and media and information literacy and their practical applications. This article discusses how computational thinking ideas are relevant to vocational education</td></tr><tr><td>A12</td><td>Computational thinking as an emerging competence domain (Yadav, et al., 2017)</td><td>n directions for future research on the role of computational thinking in primary, secondary, and vocational education. In recent decades,technology has influenced various aspects of assessment in mathematics</td></tr><tr><td>A13</td><td>Computer-based assessment of mathematics into the twenty-first century: pressures and tensions (Hoogland and Tout, 2018)</td><td>education: (1) supporting the assessment of higher-order thinking skils in mathematics, (2) rn describes the mathematics education essential for educating young people to be creative problem-solving agents in the twenty-first century.</td></tr><tr><td>A14</td><td> Confucius: Phlosopher of twentyfist entury skls</td><td>This article introduces a structured interdisciplinary framework for collections-based learning, which intrinsically privileges the observer&#x27;s viewpoint and interpretations over makers, users, anddestools &quot;twenty-first century skills&quot; with which anthropology aligns.</td></tr><tr><td>A15</td><td>Decolonizing Collections-Based Learning: Experiential Observation as an Interdisciplinary Framework for Object Study (Hodge, 2018)</td><td>This paper proposes a semi-structured experiential observation approach that unites formal art historical analysis, multisensory observations,and reflexive, polysemous cultural interpretation. The framework offers an interdisciplinary, decolonizing method of object study.</td></tr><tr><td>A16</td><td></td><td>This article shows the need for such a reframing is a tenet of cognitive flexibility theory (CFT) and the value of diverse perspectives afforded by the MOOCocracy culture. It also discusses how a CFT-based epistemic stance may further inform MOOCs&#x27; future design and practice and, a principled overlay of urgent preparation for current schooling, this framework can help us with better education designs and construction.</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>(Appedix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0</td></tr><tr><td>A17</td><td></td><td>Maker culture has expanded from its traditional niches (people interested in computers, informal education.</td></tr><tr><td>A18</td><td>eeo</td><td></td></tr><tr><td>A19</td><td>e</td><td></td></tr><tr><td>A20</td><td></td><td>武</td></tr><tr><td>A21</td><td> Developmaentft i9firs centuyslsscal  s</td><td> This paper describes an innovative model of teacher professonal learning that has evolved over</td></tr><tr><td>A22</td><td>Difentstcer ntfitend</td><td>a decade (2006 to 2016) to develop three phases of a robust, flexible framework that meets e enables the massive scaling up of access to this already validated teacher professional development model.</td></tr><tr><td>A23</td><td>Digital storytelling promoting twenty-first century skills and student engagement (Niemi and Multisilta, 2016)</td><td>This study presents the theoretical framework based on sociocultural theories. Learning occurs because of dialogical interactions between people, substances,and artifacts. This approach has been used to create the Global Sharing Pedagogy (GSP) model for the empirical study of student engagement in learning twenty-first century skills.</td></tr><tr><td>A24</td><td> </td><td>Framework for 21st Century Learning developed by the Partnership for 21st Century Learning critical thinking skills.</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>(Appedix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0 Building on frameworks created by the Partnership for 21st Century Skils, this study proposes</td></tr><tr><td>A25</td><td>Establishing the R&amp;D agenda for twenty-first century learning (Kay and Honey, 2006)</td><td>tqestfstpalentt with the tools, support, and training to make fundamental changes in their practice, the authors argue for extensive research around best practices.</td></tr><tr><td>A26</td><td>Exploring the structure of digital literacy competence assessed using authentic software applications (Reichert, et al., 2020)</td><td>Digital literacy competence (DL) is essential for students learning in a rapidly changing world. The design of the DL assessment is discussed, emphasizing the influence of digital applications and environments on DL assessments and achievement scores. Professional Learning Community (PLC) has the potential to act as leverage school-based</td></tr><tr><td>A27</td><td></td><td>curricula development and innovation to provide diverse learning experiences that achieve reweearntceiis). observations by three Grade 5 PLC facilitators in an intervention to explore how PLC facilitators can support teachers&#x27; collective learning.</td></tr><tr><td>A28</td><td>HowStudeeiat</td><td>This article presents results from a Finnish study in which 718 school pupils aged 11 to 15 were e appreciated technical skils, while the girls ranked social skills more highly.</td></tr><tr><td>A29</td><td>Implementation and sustainability of a global ICT company&#x27;s programme to help teachers integrate technlU (leanil, ac inrmayFrace,</td><td>This paper discusses implementing the &quot;Intel Teach&quot; professional development program in Gerat</td></tr><tr><td>A30</td><td>Innovative Pedagogies of the Future: An Evidence-Based Selection (Herodotou, et al.,2019)</td><td>In this work,an integrated framework with five dimensions was developed to select pedagogies for inclusion: (a) relevance to effective educational theories,(b) research evidence on the effectiveness of the proposed pedagogies, (c) correlation to the development of twenty-first century skills, (d) innovative aspects of pedagogy, and (e) level of adoption in educational practice. The selected pedagogies related to drones,robots,and citizen inquiry were linked to specific technological developments.</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>(Appendix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0</td></tr><tr><td>A31</td><td>I</td><td></td></tr><tr><td>A32</td><td></td><td>A relational survey model was used in the research. In the research, the scale developed by 武 variables. The binary knowledge fields of the research are seen in TPACK-21.</td></tr><tr><td>A33</td><td></td><td></td></tr><tr><td>A34</td><td></td><td>This study addresses twenty-first century skils in mathematics education with the maker</td></tr><tr><td>A35</td><td>Md</td><td>movement&#x27;s framework and methodological approach. The design of these learning spaces for characteristics that facilitate students&#x27; making processes are meaningful contexts, the low-floor, high-ceiling character of the open problem, and the request for a product.</td></tr><tr><td>A36</td><td>Preparing teacher-students for twenty-first century (Hakkinen,et al.,2017)</td><td>This article aims to presenta pedagogical framework for the twenty-first century learning practices in teacher education. It elaborates the processes and strategies for collaborative prabe-sosisisitierils information and communication technologies in diverse contexts.</td></tr><tr><td>A37</td><td>Re</td><td></td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td> (Appendix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0</td></tr><tr><td>A38</td><td>Rethinking learning design: Reconceptualizing the role of the learning designer in pre-service teacher preparation through a design-led approach (Kickbusch, et al.,2020)</td><td>Design-thinking approaches are practical for developing and acquiring twenty-first century skills. This study combined research on learning design, teacher self-efficacy,and design-led educational innovation to formulate the Learning DESIGN Model, a conceptual model of how learning designers can improve students&#x27; acquisition of twenty-first century skills.The model facilitates the development of design-thinking processes, skils,and mindsets in PSTs to improve their self-efficacy and enable more student-centered approaches toward curriculum design and classroom practice.</td></tr><tr><td>A39</td><td></td><td>This paper provides a framework for promoting creative design capabilities among high school students to achieve sustainable community goals. The framework can be used as a reference mdeto main structures of the curricula. Modular content and the sequencing of strategies and tactics support learning science and creative design skills.</td></tr><tr><td>A40</td><td>Selected aspects and conditions of the use of robots in STEM education for young learners as viewed by teachers and students (Smyrnova-Trybulska, et al., 2017)</td><td>This paper discusses science, technology, engineering, and mathematics (STEM) education issues. It emphasizes the need to prepare students with twenty-first century skills through STEM-related teaching, especially at the elementary level. The authors stress that using kits to build and program robots in workshops is a modern form of interdisciplinary education for children and youth.</td></tr><tr><td>A41</td><td></td><td></td></tr><tr><td>A42</td><td>Synthesizing Pedagogies and Engaging Students: Creating Blended eLearning Strategies for Library Research and Writing Instruction (Kitchens, et al.,2016)</td><td>This article identifies reference opportunities and the importance of online and face-to-face student support. This article highlights a chunked,contextual eLearning instead of a linear approach to information literacy.</td></tr><tr><td>A43</td><td>Teachers&#x27; experiences of technology-based teaching and learning in the Foundation Phase (Hannaway and Steyn, 2017)</td><td>This article describes twoqualitativeresearchcase studiesoftechnology-richshools using research methods with photovoice,semi-structured interviews and field notes.It examined teachers&#x27; experience with the Technological Pedagogical and Content Knowledge framework to understand the Foundation Phase, providing a vital contribution to understanding how technology-based teaching and learning occurs.</td></tr><tr><td>A44</td><td>Technological, pedagogical, and content knowledge in one-to-one classroom: teachers developing &quot;digital wisdom.&quot; (Blau, et al.,2016)</td><td>This article describes the results were examined through phenomenological research techniques and discussed in terms of the technological, pedagogical and content knowledge (TPACK) and &quot;digital wisdom&quot; approaches. The teachers showed significant increase in technological knowledge. However, only moderate connections between technology and pedagogy as well as between technology and content were found.</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>(Appendix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0 This paper investigates media and digital literacy at the nexus of global twenty-first century</td></tr><tr><td>A45</td><td>Singapore (Weninger, 2017)</td><td>edecatin initinitteircalingitatioithinSit xare&#x27;seutichterawith terrains competently and confidently as workers, citizens,and private individuals.</td></tr><tr><td>A46</td><td>The construct of media and information literacy in Singapore education system: global trends and local policies (Lin, et al., 2015)</td><td>This paper discusses information literacy and media literacy in Singapore education as part of its twenty-first century competencies framework with particular atention to the role of creative digital production.</td></tr><tr><td>A47</td><td>The expectations of Finnish RE student teachers of their ia Ubani, 2019)</td><td>This study examines the expectations of religious education (RE) student teachers about their professional development during their academic studies. The RE student teachers also considered the twenty-first century skills relevant for a competent RE teacher.</td></tr><tr><td>A48</td><td>The Roleof Pedagy inDevelopigLif Skili</td><td>This article examines the role of pedagogy in developing life skills (or twenty-first century skills) andchewtnhowanbeisoreoraedithirschol/uirsity arieulum.Tartilesiel teachers&#x27; professionalization. Only then can students acquire skills relevant to the twenty-first century, which employers seek.</td></tr><tr><td>A49</td><td>TPACK updated to measure pre-service teachers&#x27; twenty-first century skills (Valtonen, 2017)</td><td>Students of today and the future are expected to have the skils necessary for collaborating, problem-solving, creative and innovative thinking, and taking advantage of information and communication technology (ICT) applications. Teachers must be familiar with various pedagogical approaches and the appropriate ways to use ICT to support the development of their students&#x27; twenty-first century skills. The technological pedagogical content knowledge (TPACK) framework provides a theoretical model for studying teachers&#x27; use of ICT in education.</td></tr><tr><td>A50</td><td> Tweta</td><td>The author discusses existing strategies that will guide educators in infusing twenty-first century skils into traditional content areas such as math, English, geography,and science. Public policy regarding educational standards, professional development, assessments, and The writers introduce two perspectives developed to address twenty-first century learning and highlight how the Technology Education curriculum and Guided Inquiry are ideally suited for delivering this skill set.</td></tr></table></body></html>

Table 5. Cont.   

<html><body><table><tr><td>(Appedix A)</td><td>Title</td><td>Framework Approach for Components of Education 4.0 The motivation behind every educator&#x27;s dedication and hard work in the classroom is the</td></tr><tr><td>A51</td><td>Twenty-first century learning for teachers: helping educators bring new skills into the classroom (Wilson, 2006)</td><td>knowledge that his or her teaching will result in students&#x27; success in life. Educators are committed to implementing twenty-first century skills; they have no question that students need them to be equipped for life beyond school. The author discusses existing strategies that will guide educators in infusing twenty-first century skils into traditional content areas such as math,English, geography,and science. Ultimately, public policy regarding educational standards, professional development, assessments,and physical school structures must exist to enable educators to employ twenty-first century skills,leading to student success in contemporary life.</td></tr><tr><td>A52</td><td></td><td> through peer-supported activities using commercial off-the-shelf video games.</td></tr><tr><td>A53</td><td>Usages and impacts of the integration of information and cuicteso (Sahlin, et al., 2017)</td><td>Many schools have started implementing information and communication technologies with leningdeloi evidentin uitgomputingdevcesandhowtheyidedelementar-lel students in heir</td></tr><tr><td>A54</td><td>What does “new learning&quot; require from religious education teachers? A study of Finnish RE teachers&#x27; perceptions (Lipiainen, et al., 2020)</td><td>The study highlights the Assessment and Teaching of Twenty-first Century Skills (ATC21S) framework and its four teacher categories.For teachers,it emphasizes the ways of thinking, tools for working,and ways of working categories.</td></tr><tr><td>A55</td><td>Why American business demands twenty-first century learning: A company perspective (Knox, 2006)</td><td>Microsoft is an innovative corporation demonstrating the caliber of job skills needed in the tweplyerstetisii The author explores how Microsoft&#x27;s core competencies parallel the Partnership for 21st Century Skills learning frameworks.</td></tr><tr><td>A56</td><td> W</td><td></td></tr></table></body></html>

These articles may be of interest to support training systems in different disciplines and academic degree programs that aim to develop future skills in students and provide solutions to social, health, climate change, digital divide, and complex thinking problems (Appendix A). They can also be the objects of analysis to integrate new possibilities for design curricula to strengthen formal, non-formal, and informal training and lifelong learning. Educational agencies, ministries of education, and companies with training components can find meanings from these works.

RQ2. How many studies are in the Scopus and WoS databases over time and the dimension of learning targeted?

Figure 3 shows the learning dimensions, where it is reflected that $4 2 \%$ of the studies focused on developing the skills dimension. There, we found frameworks with titles such as Problem-solving in STEM (A2), Social Innovation Education (A41), Partnership for 21st Century Skills (A5, A24, A35, A52, A51, A29, A50), Entrepreneurial Projects (A31), Computational Thinking is a Problem-Solving Skillset (A12), ATC21S (A54), and Foster Creativity in an Inclusive Classroom (A19).

![](images/aaaff3ebef9e2fbad3e234f5611305f2650055e1ff2cabf89c35402dab37e834.jpg)  
Figure 3. Scopus and WoS databases over time and learning dimensions targeted.

In the knowledge dimension $( 3 6 \% )$ , we found frameworks entitled Bridge21 (A20), Framework for Critical Online Reasoning (A6), Dell Initiatives (A56) and Microsoft (A55), STEAM Skills Development (A40), Design-led Education Innovation Matrix (A9), and Makers and Inventors (A9).

In the meta-learning dimension $( 1 5 \% )$ , we found frameworks with titles such as Professional Learning Community (A27), TPACK (A32, A37, A43), Culturally Contextualizing the Multisensory Experience (A15), Pedagogies for Inclusion (A30), and Implicit Reasoning (A34).

Frameworks in the character dimension $( 7 \% )$ include Partnership for 21st Century Skills (A29, A14, A50) and Expectations of Religious Education (A47).

The Partnership for 21st Century Skills framework was classified into three learning dimensions: skills, knowledge, and character (not placing in meta-learning), so we consider it a good reference for application in institutions.

The data reflect that the first frameworks of 21st century competencies began to be addressed in 2006. Figure 3 is a graph where the $X$ -axis represents the year the study was published and the number of studies found. The Y-axis represents the teaching and learning dimensions of the $\mathrm { C C R } ,$ thus reflecting that the minimum number of studies focuses on applying the character and meta-learning dimensions. For educational practices, this analysis presents areas of opportunity for developing higher-level thinking processes in students, which control lower-level thinking. The idea is to internalize a growth mindset and engage students in lifelong learning to ensure sustainable participation in a global world and develop character with high personal values and virtues to achieve successful relationships [23].

# RQ3. What are the core Education 4.0 teaching and learning strategies applied in the study?

The most prevalent teaching and learning strategies that intersect with the core of Education 4.0 are presented in Figure 4 [18,34]. The most used were research strategies to apply knowledge with techniques such as research-based learning, project-based learning, and evidence-based educational innovation, followed by reflection strategies to encourage self-systemic thinking. The least used were contextual strategies to foster collaboration (A19, A39, A31, A38).

![](images/4b1589ba04d1337dfadc6f56f2e6102848342eacebc3bc884cb4370c29f0d63f.jpg)  
Figure 4. Core Education 4.0 learning strategies.

Figure 5 shows the study matrix with the article ID at the intersection of core Education 4.0 [18] and the teaching-and-learning-strategy classifications [34]. The figure highlights studies in information and communication technologies (ICT) with technology-mediated strategies to promote digital competencies (A16, A55, A18 and A45) and studies of the core infrastructure to support research strategies to apply knowledge (A17, A40, A42, A56). These stand out in the intersection.

![](images/4be56fed077b16fcf84a54f742fcbeb32b818b7581a1e50b50a007afb4a4cf44.jpg)  
Figure 5. Learning strategy studies in the Education 4.0 core.

The data in Figures 4 and 5 shed light on the educational practices where educational innovation is directed towards research strategies to apply knowledge. The techniques include research-based learning, project-based learning, and evidence-based educational innovation. The most significant gap worldwide reflects the need to conduct more research to implement and equip educational institutions’ technological infrastructure and integrate teaching and learning methods with technology.

RQ4. Who are the stakeholders identified in the publications, and what core Education 4.0 competencies have been worked on in the frameworks?

Figure 6 shows the learning dimensions of the Center for Curriculum Redesign (CCR) (Skills, Knowledge, Character, and Meta-learning). The most used are Skills (32 studies) and Knowledge (27 studies). The least are Meta-learning (11 studies) and Character (5 studies). Notably, the main stakeholders identified in the 21st century frameworks are students, ahead of teachers and training partners in industry and other sectors.

![](images/198f09ed8c891071b1d421fdbf3c2f333c5a5834d8ea732d4b5c1009a021b5ef.jpg)  
Figure 6. Stakeholders and learning dimensions.

In contrast, Figure 7 highlights the finding of stakeholders (teachers, students, school managers) in the core components of Education 4.0 [4] to whom the frameworks were applied. The most significant number of studies focused on students. It is interesting to note the lack of studies on the Education 4.0 core components in infrastructure and information technologies (ICT).

![](images/6a846b31458b6624f0822b859196c93baf6940f1f3bbd7ecbb25691ba9925878.jpg)  
Figure 7. Stakeholders and Education 4.0.

Mapping competencies and stakeholders opens the perspective for cross-sectoral work. The academic, governmental, social, and business sectors have opportunities for competencies training, with excellent potential for intersecting linkages. The opportunities for training in curricular development, technologies, resources, and training programs stand out. In addition, there are implications for educational research in terms of following up on results, critical factors, and improvements that generate new knowledge, products, and services.

# 4. Discussion

This study presents the SCOPUS and WoS databases articles that refer to 21st century frameworks up to 2021. Table 5 shows 56 studies found with 21st century frameworks. In general, they highlight successful cases in educational practices. Some point out the teaching and learning strategies to trigger their students and teachers’ competencies and led to various educational institutions’ initiatives. The WEF 2021 report [2] presents the social problems during the global pandemic. The 2021 report of the 2030 Agenda [1] reveals that the efforts to achieve SDG 4 objectives have been negatively impacted by the months of students’ absence from school, hence the importance of incorporating educational scenarios that focus on developing skills demanded by the workforce of the future and Industry 4.0. Analyzing these studies reveals the gaps in formulating new competencies, learning methods, and frameworks by school managers and schools. Other gaps include developing competencies with digital technological tools necessary to address the primary post-pandemic social problems, raising awareness among governments and institutions of the gap between the “haves” and “have-nots.” Additionally, there is little research on the risks of continuing traditional teaching and learning methods and evolving to a 4.0 model.

To perform adequately in the changing world, citizens must manage various digital tools, be autonomous, take charge of their security and identity in social networks, and be responsible and ethical. Figure 3 reflects the minimal studies found in WoS and SCOPUS through 2021 that focus on the CCR character and meta-learning dimensions. Character education builds the foundation for lifelong learning, successful relationships in the home, community, workplace, and values development. Meta-learning involves higher-level thought processes, which control lower-level thoughts, and promotes the internalization of a growth mindset [23]. Study A28 presented a future skills instrument for students to choose the skills they consider most important. The most highly rated were social skills and collaboration. Boys appreciated technical skills, while the girls ranked social skills more highly. Refs. [20,21] point out that future jobs depend on cognitive and emotional factors that allow individuals to analyze their environments and make the best decisions. Ref. [8] exemplifies how educational robotics and programming can develop soft skills through emotional management and moral dilemmas. To teach character and meta-learning, trainers can design teaching and learning activities with reflection strategies to encourage systemic self-learning, contextual strategies to foster collaboration, research-based learning, project-based learning, and evidence-based educational innovations using information and communication technologies.

To guide good practices, institutions can build a repository of information for teachers with methodological guides on teaching–learning strategies and the technologies to be applied for their students on topics such as creativity, complex decision-making, data science, use of information technologies, and socio-emotional skills. Figure 4 shows that the teaching–learning strategies most used to develop Education 4.0 core competencies [18] are research strategies to apply knowledge and reflection strategies to promote self-learning (auto-systemic thinking) [34]. Figure 5 shows that fewer studies were found in the Education 4.0 infrastructure and ICT core components [18], highlighting a gap in the learning strategies that employ information and communication technologies and promote digital skills. One of the crucial components for empowering teachers and students in these practices will play the role of the library, since the formation of proactive information culture strengthens an academic’s position in creating and use the information [36]. Increasing academic performance and motivation [32] through creativity, collaboration, critical thinking, and communication [27] can challenge teachers who are not trained with new approaches.

The A51 study notes that teachers find it frustrating that schools do not have adequate resources to teach 21st century skills and suggests addressing the need for physical, technological, and policy infrastructures, curricular materials, and best practices for meaningful teaching and assessment. Scenarios with immersive technology [37] such the inclusion of Immersive Virtual Reality (IVR), associated with manipulative/experiential activities based on the STEM approach positively impacts the scientific-mathematical attitudes of participating students [38].Rethinking learning objectives to develop the four dimensions of learning (skills, knowledge, character, and meta-learning) infers that schools have equipment with an internet connection, access to digital libraries, cloud tools to create educational resources, and laboratories with robotics, augmented reality, and virtual reality practices. University maker spaces provide and environment for collaborative learning and reinforce the teaching-learning process [39]. Schools must have an educational model that uses quality assessments of learning and skills acquisition for Industry 4.0 and facilitates the harmonious interactions of people in a digital, globally connected world.

If an institution plans to incorporate an Education 4.0 framework, it should address skills development comprehensively (soft skills and hard skills) in students, teachers, and managers, and plan strategies to equip classrooms and provide relevant technological infrastructure and digital resources to teachers and stakeholders. Figure 6 shows that the frameworks found in our review focus on the learning dimensions, skills, and knowledge, and few focus on character and meta-learning. Figure 7 shows the lack of frameworks to support teachers and schools in preparing for Education 4.0 and Industry 4.0.

Along these lines, study A17 reported success in a primary school that used a makerspace, where multiple levels of interactions with various tools, activities, and contexts enabled computational thinking, computational decision making, and design-driven education. Suggestions to promote and enhance current creative education in STEM Maker education and meet the needs of students and teachers [40] recommend the development of new learning materials and online learning systems through the integration of product design and computer-aided design (CAD).

Study A40 described STEAM competencies developed in a robotics laboratory. Although it is expected to develop competencies in students, it is still necessary to create models that cater to teachers and school managers and provide the necessary resources to strengthen the educational institutions [25], such the theoretical model of Van den Hurk et al. (2019) [41] focuses on three types of factors that may affect persistence of learning in STEM: (1) environmental factors; (2) school-level factors; and (3) student-level factors. Schools must make better decisions to equip the learning environments of Generation Z students [26] with recreational, comfortable, sustainable, and accessible spaces [18]. An other important aspect of STEM education is the design of STEM activities, for this design influences how the activities mediate students’ experiences in the STEM Classroom [42]. Mechanisms can be established to implement constructive educational reforms in higher education curricula. Additionally, emphasis should be placed on building educational frameworks based on scientific development and ethics [50] to trigger the development of future skills for Industry 4.0 [14,15]. The frameworks should support financially sustainable models over time and deploy disruptive technologies, equip spaces to train teachers, parents, and educational managers, and evolve towards Education 4.0 in the shortest possible time.

# 5. Conclusions

Integrating the core 4.0 educational components with Industry 4.0 is the beginning of a model that involves the different stakeholders in the education system in flexible, pedagogical practices. This integration considers the technology that supports learning, connectivity, storage infrastructure, institutional guidelines, organizational processes, practices to promote innovation, digital skills training for teachers (doing and being), and coexistence with digital native students.

This article focused on analyzing which components of Education 4.0 are being used in 21st century frameworks and which teaching and learning strategy is the most successful for developing future skills. The data reveal (a) that literature on frameworks highlight case studies and teaching and learning strategies to develop 21st century skills; (b) the skills and knowledge learning dimensions have comprehensive studies, and there are areas of opportunity for studies on the development of character and meta-learning skills; (c) the most used teaching and learning strategies setting the trends for educational innovation are research strategies to apply knowledge and reflection and encourage auto-systemic thinking; (d) the components of Education 4.0 most addressed are learning methods and competencies; there is a lack of studies aimed at strengthening the infrastructure of schools and the use of ICT, and (e) there is a notable absence of frameworks aimed at teachers and managers and applying strategies to strengthen educational innovation in schools.

The implications for educational practice are to generate educational models and formal and informal educational practices that scale the development of 21st century competencies to a complex, changing world. It is essential to clearly understand the objectives and indicators of employment competencies to assess competency models worldwide, updating them periodically using research data from educational institutions. The social transformations brought about by the technological revolution in communications have directly impacted the way people act. The dynamics of Industry 4.0 in the present and the future present a reality that makes changes imperative for Education 4.0: Educational models must integrate artificial intelligence, data management, ubiquitous technologies, robots, and cloud computing to facilitate, among many other things, reducing the post-pandemic collateral damage of a world in complete technological change.

Reconstructing knowledge and the ways to apply it, not only in doing but also in perceiving, can serve as a starting point to generate the necessary changes to construct a sustainable development future in all disciplines of knowledge. Similarly, the implications of research results are to follow up with training that generates new knowledge, services, or products in 21st century education. Training in complex reasoning skills, with scientific, critical, creative, innovative, and systemic thinking, and developing habits for wellbeing, mental health, and interpersonal relationships will support training that leads to problemsolving and attention to social needs. Another educational challenge is to use disruptive and intelligent technologies that develop integrated soft and hard skills.

The value of this study was to identify trends in competencies for teachers, trainers, designers, researchers, and decision-makers interested in educational innovation. It invites further exploration of 21st century competency development and its possibilities.

Funding: This publication is a product of the project "OpenResearchLab: innovation with artificial intelligence and robotics to scale domain levels of reasoning for complexity” (ID Novus N21-207), funded by the Institute for the Future of Education, Tecnologico de Monterrey.

Institutional Review Board Statement: Not applicable.

Informed Consent Statement: Not applicable.

Data Availability Statement: The dataset presented in this study is openly available at https:// zenodo.org/record/5574275 (accessed on 25 October 2021).

Acknowledgments: The authors acknowledge the technical support of WritingLab, Institute for the Future of Education, Tecnologico de Monterrey, Mexico, in the production of this work.

Conflicts of Interest: The authors declare no conflict of interest.

# Appendix A

<html><body><table><tr><td>Id</td><td>Reference APA</td></tr><tr><td>A1</td><td>Tiemann, R.and Annaggar,A. (2020). A framework forthetheory-driven design of digital learning environments (FDDLEs)using the example of problem-solving in chemistry education. Interactive Learning Enuironments,1-14.</td></tr><tr><td>A2</td><td>Priemer,B.,Eilerts,K.,Filler,A.,Pinkwart,N.,Rosken-Winter, B.,Tiemann,R.,and Zu Belzen,A.U. (2020). A framework to foster problem-solving in STEMand computing education. Research in Science &amp; Technological Education,38(1),105-130.</td></tr><tr><td>A3</td><td></td></tr><tr><td>A4</td><td>Menea,Ma</td></tr><tr><td>A5</td><td></td></tr><tr><td>A6</td><td>Molerov,D., Zlatkin-Troitschanskaia,O.,Nagel,M.T.,Bruckner, S.,Schmidt,S.,and Shavelson,R. J. (2020). Assessing University Students&#x27; Critical Online Reasoning Ability: A Conceptual and Assessment Framework with Preliminary Evidence.</td></tr><tr><td>A7</td><td>Shavelson,R.J., Zlatkin-Troitschanskaia,O., Beck, K., Schmidt,S.,and Marino,J.P. (2019).Assessmentof university students&#x27;critical thinking: Next-generation performance assessment. International Journal of Testing,19(4),337-362.</td></tr><tr><td>A8</td><td></td></tr><tr><td>A9</td><td>wtut,a.</td></tr><tr><td>A10</td><td>e</td></tr><tr><td>A11</td><td></td></tr><tr><td>A12</td><td></td></tr><tr><td>A13</td><td>Hoturnd,Kt,D.)stfisitotyf</td></tr><tr><td>A14</td><td></td></tr><tr><td>A15</td><td></td></tr><tr><td>A16</td><td>Hu,Y.and Spiro,R.J. (2021). Design for now,but with the future in mind: a &quot;cognitive flexibility theory&quot; perspective on online learning through the lens of MOOCs. Educational Technology Research and Development, 69(1),373-378.</td></tr><tr><td>A17</td><td>Laru,J., Vuopala,E.,Iwata,M.,Pitkänen,K., Sanchez,I., Mantymaki, A,...and Naykki,J. (2019). Designing seamless learning activities for school visitors in the context of Fab Lab Oulu. In Seamless</td></tr><tr><td>A18</td><td>Learning (pp. 153-169). Springer, Singapore. ad</td></tr><tr><td>A18</td><td>Mad</td></tr></table></body></html>

<html><body><table><tr><td>1d</td><td>Reference APA</td></tr><tr><td>A19</td><td>d</td></tr><tr><td>A20</td><td>i</td></tr><tr><td>A21</td><td>JavedM.S.,.AA.().,Dfattyfrstrsale f</td></tr><tr><td>A22</td><td>e</td></tr><tr><td>A23</td><td> NiemiHniJ)l</td></tr><tr><td>A24</td><td>K</td></tr><tr><td>A25</td><td>K</td></tr><tr><td>A26</td><td>Reichert,F., Zhang, D.J.,Law, N. W., Wong,G.K.,and de la Torre,J. (2020). Exploring the structure of digital literacy competence assessed using authentic software applications.Educational Technology Research and Development, 68(6),2991-3013.</td></tr><tr><td>A27</td><td> </td></tr><tr><td>A28</td><td>A</td></tr><tr><td>A29</td><td>Arati,D.,Todorova, A.,and Merrett, R. (2011). Implementation and sustainability of a global ICT company&#x27;s programme to help teachers integrate technology into learning and teaching in Germany, France,and the UK.Research in Learning Technology,19.</td></tr><tr><td>A30</td><td>Herodotou, C., Sharples,M., Gaved, M, Kukulska-Hulme,A.,Rienties,B.,Scanlon,E,and Whitelock,D. (2019). Innovative pedagogies of the future: An evidence-based selection. In Frontiers in Education (Vol. 4, p. 113). Frontiers.</td></tr><tr><td>A31</td><td></td></tr><tr><td>A32</td><td></td></tr><tr><td>A33</td><td>Gold,A. U.,Oonk,D.J,Smith,L., Boykoff,M.T.,Osnes, B.,and Suivan,S.B. (2015). A lens o climate change: Making climate meaningful through student-produced videos. Journal of Geography, 114(6), 235-246.</td></tr><tr><td>A34</td><td>d</td></tr><tr><td>A35</td><td>Doorman, M., Bos,R., de Haan, D., Jonker, V., Mol, A.,and Wijers, M. (2019). Making and implementing a mathematics day challenge as a makerspace for teams of students. International Journal of Science and Mathematics ducation,7(1),49-165.</td></tr><tr><td>A36</td><td>Hakinen,PJrvela,,kitaloieg,K,onen,A,Nki,PndValonenT.(2).Prin teacher-students for twenty-first century learning practices (PREP 21): a framework for enhancing collaborative problem-solving and strategic learning skills. Teachers and Teaching,23(1),25-41.</td></tr><tr><td>A37</td><td></td></tr></table></body></html>

<html><body><table><tr><td>Id</td><td>Reference APA</td></tr><tr><td>A38</td><td>Kickbusch,S., Wright, N., Sternberg,J.,and Dawes,L. (2020). Rethinking learning design: Reconceptualizing the role of the learning designer in pre-service teacher preparation through a design-led approach. International Journal of Design Education,14(4),29-45.</td></tr><tr><td>A39</td><td>e</td></tr><tr><td>A40</td><td>Smyrnova-Trybulska,E., Morze,N.,Kommers,P., Zuziak, W.,and Gladun,M. (2017). Selected aspects and conditions of the use of robots in STEM education for young learners as viewed by teachers and students. Interactive Technology and Smart Education.</td></tr><tr><td>A41</td><td></td></tr><tr><td>A42</td><td>Kitchens, R. K., and Barker, M. E. (2016). Synthesizing pedagogies and engaging students: Creating blended eLearning strategies for library research and writing instruction. The Reference Librarian,57(4), 323-335.</td></tr><tr><td>A43</td><td>Ha</td></tr><tr><td>A44</td><td>Blau,LPeledY</td></tr><tr><td>A45</td><td></td></tr><tr><td>A46</td><td>Lin,T. B., Mokhtar,I. A.,and Wang, L.Y. (2015). Theconstruct of media and information literacy in Singapore education system: global trends and local policies. Asia Pacific Journal of Education, 35(4), 423-437.</td></tr><tr><td>A47</td><td>Viinikka, K.-,and Ubani, M. (2019). The expectations of Finnish RE student teachers of their professional development in their academic studies in the light of twenty-first century skills. Journal of Beliefs &amp; Values, 40(4),447-463.</td></tr><tr><td>A48</td><td> Gupta,R, (2021).TheRole of PedagyinDeopingLf Sils, ari: The Joural of pled Econromic</td></tr><tr><td>A49</td><td>Valtonen,T.,Sointu,E.,Kukkonen,J.,Kontkanen,S.,Lambert, M. C.,and Makitalo-Siegl, K. (2017). TPACK updated to measure pre-service teachers&#x27; twenty-first century skils. Australasian Journal of Educational Technology, 33(3).</td></tr><tr><td>A50</td><td></td></tr><tr><td>A51</td><td></td></tr><tr><td>A52</td><td>Engerman,J. A., Carr-Chellman, A. A.,and MacAllan, M. (2019). Understanding learning in video games: A phenomenological approach to unpacking boy cultures in virtual worlds. Education and</td></tr><tr><td>A53</td><td>Information Technologies,24(6),3311-3327. Sahlin,J.S.,Tsertsidis,A.,and Islam, M.S.(2O17). Usages and impacts of the integrationof information and communication technologies (ICTs) in elementary classrooms: a case study of Swedish municipality schools.Interactive Learning Environments,25(5),561-579.</td></tr><tr><td>A54</td><td>Lipiainen,T., Ubani, M., Viinikka,K.,and Kalioniemi, A. (2020).What does &quot;new learning&quot; require from religious education teachers? A study of Finnish RE teachers&#x27; perceptions. Journal of Religious Education,</td></tr><tr><td>A55</td><td>68(2),213-231.</td></tr><tr><td>A56</td><td></td></tr></table></body></html>

# References

1. UN. The Sustainable Development Goals Report. 2020. Available online: https://unstats.un.org/sdgs/report/2020/ (accessed on 5 August 2021).   
2. McLennan, M. The Global Risks Report. 2021 16th Edition. Available online: http://www3.weforum.org/docs/WEF_The_ Global_Risks_Report_2021.pdf (accessed on 5 August 2021).   
3. Partnership for 21st Century Skills. Framework for 21st Century Learning. 2019. Available online: https://bit.ly/3FS9JBC (accessed on 2 April 2021).   
4. Tecnologico de Monterrey. Razonamiento para la Complejidad. In Tecnologico de Monterrey, 7 Competencias con las que el Tec Busca Preparar a sus Estudiantes; 2019; Available online: https://bit.ly/3AsM6NL (accessed on 12 October 2021).   
5. Morin, E.; Pakman, M. Introducción al Pensamiento Complejo; Gedisa: Barcelona, Spain, 2011; ISBN 978-84-7432-518-8.   
6. Ramírez-Montoya, M.S.; Álvarez-Icaza, I.; Sanabria-Zepeda, J.C.; López-Caudana, E.O.; Alonso, P.E.; Miranda, J. Scaling Complex Thinking for Everyone through Open Science: A Conceptual Methodological Framework. In Proceedings of the 9th International Conference on Technological Ecosystems for Enhancing Multiculturality TEEM21, Barcelona, Spain, 26–29 October 2021; University of Barcelona: Barcelona, Spain, 2021; pp. 806–811.   
7. Chaka, C. Skills, Competencies and Literacies Attributed to 4IR/Industry 4.0: Scoping Review. IFLA J. 2020, 46, 369–399. [CrossRef]   
8. Álamo Venegas, J.J.; Alonso Díaz, L.; Yuste Tosina, R.; López Ramos, V.M. La Dimensión Educativa de la robótica: Del Desarrollo del Pensamiento al Pensamiento Computacional en el aula. Campo Abierto. Rev. de Educ. 2021, 40, 2. Available online: https://bit.ly/3jbxUkG (accessed on 15 September 2021).   
9. van Laar, E.; van Deursen, A.J.A.M.; van Dijk, J.A.G.M.; de Haan, J. The Relation between 21st-Century Skills and Digital Skills: A Systematic Literature Review. Comput. Hum. Behav. 2017, 72, 577–588. [CrossRef]   
10. Noh, S.C.; Karim, A.M.A. Design Thinking Mindset to Enhance Education 4.0 Competitiveness in Malaysia. IJERE 2021, 10, 494. [CrossRef]   
11. González-Salamanca, J.C.; Agudelo, O.L.; Salinas, J. Key Competencies, Education for Sustainable Development and Strategies for the Development of 21st Century Skills. A Systematic Literature Review. Sustainability 2020, 12, 10366. [CrossRef]   
12. Gleason, N.W. (Ed.) Higher Education in the Era of the Fourth Industrial Revolution; Springer: Singapore, 2018; ISBN 9789811301933. Available online: https://library.oapen.org/handle/20.500.12657/23279 (accessed on 16 September 2021).   
13. Hong, C.; Ma, W.W.K. (Eds.) Introduction: Education 4.0: Applied Degree Education and the Future of Work. In Applied Degree Education and the Future of Work; Lecture Notes in Educational Technology; Springer: Singapore, 2020; pp. 1–13. ISBN 9789811531415.   
14. PricewaterhouseCoopers (PwC). Will Robots Really Steal Our Jobs? An International Analysis of the Potential Long-Term Impact of Automation 2018. Available online: https://www.pwc.co.uk/economic-services/assets/international-impact-of-automationfeb-2018.pdf (accessed on 25 October 2021).   
15. Bonfield, C.A.; Salter, M.; Longmuir, A.; Benson, M.; Adachi, C. Transformation or Evolution? Education 4.0, Teaching and Learning in the Digital Age. High. Educ. Pedagog. 2020, 5, 223–246. [CrossRef]   
16. Karlos de Sousa Oliveira, K.; André Cavalcante de Souza, R. Habilitadores Da Transformação Digital Em Direção à Educação 4.0. Renote 2020, 18, 1. [CrossRef]   
17. Ciolacu, M.; Tehrani, A.F.; Beer, R.; Popp, H. Education 4.0—Fostering Student’s Performance with Machine Learning Methods. In Proceedings of the 2017 IEEE 23rd International Symposium for Design and Technology in Electronic Packaging (SIITME), Constanta, Romania, 26–29 October 2017; pp. 438–443.   
18. Miranda, J.; Navarrete, C.; Noguez, J.; Molina-Espinosa, J.-M.; Ramírez-Montoya, M.-S.; Navarro-Tuch, S.A.; Bustamante-Bello, M.-R.; Rosas-Fernández, J.-B.; Molina, A. The Core Components of Education 4.0 in Higher Education: Three Case Studies in Engineering Education. Comput. Electr. Eng. 2021, 93, 107278. [CrossRef]   
19. García Vaquero, M.; Sánchez-Bayón, A.; Lominchar, J. European Green Deal and Recovery Plan: Green Jobs, Skills and Wellbeing Economics in Spain. Energies 2021, 14, 4145. [CrossRef]   
20. Alles, M.A. Desarrollo del Talento Humano Basado en Competencias; Ediciones Granica SA: Buenos Aires, Argentina, 2007.   
21. Duque Ceballos, J.L.; García Solarte, M.; Hurtado Ayala, A. Influencia de la inteligencia emocional sobre las competencias laborales: Un estudio empírico con empleados del nivel administrativo. Estud. Gerenc. 2017, 33, 250–260. [CrossRef]   
22. OCDE. The Future of Education and Skills. Education 2030. 2018. Available online: http://go.uv.es/1fDpQnn (accessed on 12 August 2021).   
23. Fadel, C.; Bialik, M.; Trilling, B.; Schleicher, A. Four-Dimensional Education: The Competencies Learners Need to Succeed; Center for Curriculum Redesign: Boston, MA, USA, 2015; ISBN 978-1-5186-4256-2.   
24. Cedefop. Annual Report 2014; Cedefop Information Series; Publications Office of the European Union: Luxembourg, 2015; Available online: https://bit.ly/3AOReKz (accessed on 1 September 2021).   
25. Himmetoglu, B.; Aydug, D.; Bayrak, C. Education 4.0: Defining the teacher, the student, and the school manager aspects of the revolution. Turk. Online J. Distance Educ. 2020, 21, 12–28. [CrossRef]   
26. Aziz Hussin, A. Education 4.0 Made Simple: Ideas For Teaching. IJELS 2018, 6, 92. [CrossRef]   
27. Salmon, G. May 4 Be with You: Creating Education 4.0. J. Learn. Dev. 2019, 6, 95–115. Available online: https://bit.ly/3aKxXiX (accessed on 10 September 2021).   
28. Shirazi, F.; Hajli, N. IT-Enabled Sustainable Innovation and the Global Digital Divides. Sustainability 2021, 13, 9711. [CrossRef]   
29. Ferrari, A. DIGCOMP: A Framework for Developing and Understanding Digital Competence in Europe. 2013. Available online: https://tinyurl.com/yc9at8t6 (accessed on 5 April 2021).   
30. Bacigalupo, M. Entrepreneurship as a competence. In World Encyclopedia of Entrepreneurship; Edward Elgar Publishing: Cheltenham, UK, 2021.   
31. Rayna, T.; Striukova, L. Fostering Skills for the 21st Century: The Role of Fab Labs and Makerspaces. Technol. Forecast. Soc. Chang. 2021, 164, 120391. [CrossRef]   
32. Vivas-Fernandez, L.; Sáez-López, J.M. Integración de la robótica educativa en Educación Primaria. Rev. Latinoam. De Tecnol. Educ.-RELATEC 2019, 18, 107–129.   
33. Wing, J.M. Computational thinking. Commun. ACM 2006, 49, 33–35. [CrossRef]   
34. Ramírez-Montoya, M.S. Modelos y Estrategias de Enseñanza para Ambientes Innovadores; Editorial Digital: Monterrey, México, 2012.   
35. Pradas Montilla, S. La Neurotecnología Educativa. Claves Del Uso de La Tecnología En El Proceso de Aprendizaje. ReiDoCrea Rev. Electrónica De Investig. Docencia Creat. 2017, 6, 40–48. [CrossRef]   
36. Deja, M.; Rak, D.; Bell, B. Digital Transformation Readiness: Perspectives on Academia and Library Outcomes in Information Literacy. J. Acad. Librariansh. 2021, 47, 102403. [CrossRef]   
37. Seufert, C.; Oberdörfer, S.; Roth, A.; Grafe, S.; Lugrin, J.-L.; Latoschik, M.E. Classroom Management Competency Enhancement for Student Teachers Using a Fully Immersive Virtual Classroom. Comput. Educ. 2022, 179, 104410. [CrossRef]   
38. Silva-Díaz, F.; Carrillo-Rosúa, J.; Fernández-Plaza, J.A. Uso de Tecnologías Inmersivas y Su Impacto En Las Actitudes CientíficoMatemáticas Del Estudiantado de Educación Secundaria Obligatoria En Un Contexto En Riesgo de Exclusión Social. Educar 2021, 57, 119–138. [CrossRef]   
39. Santos, A.F.; Barber III, D.; Harris, M.; Haymore, J. What Can Universities Learn From Organizational Creative Space Design Research? A Look at Maker Spaces. JHETP 2021, 21. [CrossRef]   
40. Wong, C.; Shih, Y. Enhance STEM Education by Integrating Product Design with Computer-Aided Design Approaches. CADandA 2021, 19, 694–711. [CrossRef]   
41. van den Hurk, A.; Meelissen, M.; van Langen, A. Interventions in Education to Prevent STEM Pipeline Leakage. Int. J. Sci. Educ. 2019, 41, 150–164. [CrossRef]   
42. Daher, W.; Awawdeh Shahbari, J. Design of STEM Activities: Experiences and Perceptions of Prospective Secondary School Teachers. Int. J. Emerg. Technol. Learn. 2020, 15, 112. [CrossRef]   
43. Kayan-Fadlelmula, F.; Sellami, A.; Abdelkader, N.; Umer, S. A Systematic Review of STEM Education Research in the GCC Countries: Trends, Gaps and Barriers. Int. J. STEM Educ. 2022, 9, 2. [CrossRef]   
44. Brereton, P.; Kitchenham, B.A.; Budgen, D.; Turner, M.; Khalil, M. Lessons from Applying the Systematic Literature Review Process within the Software Engineering Domain. J. Syst. Softw. 2007, 80, 571–583. [CrossRef]   
45. Higgins, J.P.; Green, S. Cochrane handbook for systematic reviews of interventions 4.2.6. Cochrane Libr. 2006, 4, 49–55.   
46. Kitchenham, B. Procedures for Performing Systematic Reviews; Keele University: Keele, UK, 2004; Volume 33, pp. 1–26. Available online: https://bit.ly/2XnwE6y (accessed on 20 September 2021).   
47. Chambers, D.; Rodgers, M.; Golder, S.; Pepper, C.; Todd, D.; Woolacott, N. Centre for Reviews and Dissemination. 2009. Available online: https://bit.ly/3FSM9oe (accessed on 20 September 2021).   
48. García-Peñalvo, F.J. Mapeos Sistemáticos de Literatura, Revisiones Sistemáticas de Literatura y Benchmarking de Programas Formativos. 2017. Available online: http://repositorio.grial.eu/handle/grial/1056 (accessed on 20 September 2021).   
49. Page, M.J.; McKenzie, J.E.; Bossuyt, P.M.; Boutron, I.; Hoffmann, T.C.; Mulrow, C.D.; Shamseer, L.; Tetzlaff, J.M.; Akl, E.A.; Brennan, S.E.; et al. The PRISMA 2020 Statement: An Updated Guideline for Reporting Systematic Reviews. BMJ 2021, 372, n160. [CrossRef]   
50. Sifaki, E.; Petousi, V. Contextualising Harm in the Framework of Research Misconduct. Findings from Discourse Analysis of Scientific Publications. IJSD 2020, 23, 149. [CrossRef]